#define u32 unsigned int
#define u8 unsigned char
#define u16 unsigned short


/* inode information specific to ProDOS "inodes." Note that this structure is
 never actually instantiated. It is simply overlaid upon inode.u.minix_i to
 avoid the need to modify fs.h in the standard Linux source. Obviously, this
 limits the prodos_inode_info structure to a size <= the size of
 struct minix_inode_info. */
struct dos33_inode_info {
	u8 i_flags;
	u8 i_filetype;
	u8 i_stype;
	u16 i_key;
	u16 i_auxtype;
	u8 i_access;
};

struct dos33_track_sector{
   u8 track;
   u8 sector;
} __attribute__((packed));

struct dos33_vtol {
   u8 four;
   u8 catalog_track;
   u8 catalog_sector;
   u8 dos_version;
   u8 unused1[2];
   u8 volume;
   u8 unused2[0x20];
   u8 ts_pairs;
   u8 unused3[8];
   u8 last_track;
   u8 allocation_direction;
   u8 unused4[2];
   u8 tracks_per_disk;
   u8 sectors_per_track;
   u16 bytes_per_sector;
   u32 bitmaps[0x23];
   u8 unused5[0x3b];
} __attribute__((packed));

struct dos33_file_t {
   u8 first_tsl_track;
   u8 first_tsl_sector;
   u8 file_type;
   u8 file_name[0x1e];  /* high bit set, padded with spaces */
   u16 num_sectors;
} __attribute__((packed));

struct dos33_catalog_sector {
   u8 unused1;
   u8 next_track;
   u8 next_sector;
   u8 unused[8];
   struct dos33_file_t files[7]; 
} __attribute__((packed));

struct dos33_ts_list {
   u8 unused1;
   struct dos33_track_sector next;
   u8 unused2[2];
   u16 current_sectors_deep;
   u8 unused3[5];
   struct dos33_track_sector data_location[122];
} __attribute__((packed));
